//gapsensor reads around 0 when blocked, 230 when open
const int GapSenseSwitchVal = 100;
const int motorPin = 9;
const int motorStepTime=10;
const int motorFinalStepTime=40;
const int startcharacter =49; //a 1 over Serial port triggers a feeding
int phase =0;
unsigned long debounceDelay = 1;    // the debounce time; increase if the output flickers

// the setup routine runs once when you press reset:
void setup() {
  // initialize serial communication at 9600 bits per second:
  Serial.begin(9600);
  pinMode(motorPin, OUTPUT); 
  //start at phase where nothing has been requested
  phase=0;
}

// the loop routine runs over and over again forever:
void loop() {
  int incomingByte = 0;


//monitor incoming serial line to trigger a feeding
  if (Serial.available() > 0) {
    // read the incoming byte:
      incomingByte = Serial.read();
      if (incomingByte==49) {
        //move to phase where next feed is requested
        Serial.println("Request Received");
        phase=1;
      }
  }  

  if (phase==1) {
    if (getIsGapStatusOpen()==true) {
      //we want to start assuming we are already in a gap
      Serial.println("We started in a feeding hole position - advance to blank space");
      phase=2;
    }
    else {
      //we want to start assuming we are already in a block
      Serial.println("We started in a blank space, advance directly to feeding hole");
      phase=3;
    }
  }
  
  if (phase==2) {
    if (getIsGapStatusOpen()==true) {
      Serial.println("Advancing to blank space");
      motorAdvance(motorStepTime);
      //analogWrite(motorPin, motorSpeed);
    }
    else {
      //we are now over a solid item and have to proceed to an openinng
      phase=3;
    }
  }
  
  if (phase==3) {
    if (getIsGapStatusOpen()==false) {
      Serial.println("Advancing to feeding hole");
      motorAdvance(motorStepTime);
      //analogWrite(motorPin, motorSpeed);
    }
    else {
      //we have reached another opening - stop turning motor
      Serial.println("Feeding hole reached");
      //tuning
      motorAdvance(motorFinalStepTime);//digitalWrite(motorPin, LOW);
      phase=0;
    }
  }
  
  delay(1);        // delay in between reads for stability
}

bool getIsGapStatusOpen()
{
  int gapSensorValue;
  bool bIsGapStatusOpen;

  //lets take 3 readings with a delay - I'm not sure if bounce is an issue
  gapSensorValue = analogRead(A0);
  delay(debounceDelay);
  gapSensorValue = gapSensorValue + analogRead(A0);
  delay(debounceDelay);
  gapSensorValue = gapSensorValue + analogRead(A0);

  Serial.println(gapSensorValue);
  if (gapSensorValue > (GapSenseSwitchVal*3)) {
    bIsGapStatusOpen=true;
  }
  else {
    bIsGapStatusOpen=false;
  }
return bIsGapStatusOpen;
}

void motorAdvance(int stepTime)
{
      digitalWrite(motorPin, HIGH);
      delay(stepTime);
      digitalWrite(motorPin, LOW);
      delay(10);

}




