
// Module names are of the form poly_<inkscape-path-id>().  As a result,
// you can associate a polygon in this OpenSCAD program with the corresponding
// SVG element in the Inkscape document by looking for the XML element with
// the attribute id="inkscape-path-id".

// fudge value is used to ensure that subtracted solids are a tad taller
// in the z dimension than the polygon being subtracted from.  This helps
// keep the resulting .stl file manifold.
fudge = 0.1;
intdia=4.1;

module poly_path3007(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-40.462005,54.999823],[-43.988589,53.928598],[-47.155803,52.603723],[-48.696502,51.925891],[-50.045160,51.637348],[-51.378515,51.724816],[-52.873305,52.175023],[-57.391072,53.036295],[-63.583378,53.269948],[-69.649523,52.896513],[-72.072567,52.488554],[-73.788809,51.936523],[-75.197871,51.117610],[-76.066012,50.216573],[-76.488976,49.082510],[-76.562508,47.564523],[-75.776392,43.115987],[-74.047968,36.409060],[-72.020412,29.735115],[-70.336901,25.385523],[-69.831442,23.143670],[-69.469656,18.582575],[-69.179507,2.550143],[-69.179507,-18.122637],[-66.165041,-24.438877],[-63.420413,-29.313972],[-60.134797,-33.107460],[-55.719138,-36.358131],[-49.584383,-39.604777],[-45.712716,-41.264931],[-41.756928,-42.547041],[-37.339867,-43.554229],[-32.084383,-44.389617],[-17.179507,-46.808587],[-12.262872,-47.606529],[-7.132610,-47.787001],[-1.499458,-47.342916],[4.925849,-46.267187],[9.456825,-45.411158],[12.254310,-45.125815],[14.118715,-45.411158],[15.850449,-46.267187],[18.988174,-47.426412],[22.630169,-47.908567],[24.763496,-48.073110],[26.670523,-48.639014],[28.604953,-49.714694],[30.820489,-51.408567],[33.631205,-53.647632],[35.497565,-54.661366],[37.016220,-54.621408],[38.783819,-53.699397],[39.899187,-53.170981],[41.044525,-53.064907],[44.304179,-54.199397],[47.440453,-55.390311],[50.602444,-55.816384],[54.333543,-55.485085],[59.177139,-54.403887],[64.244175,-53.399210],[65.479028,-53.650379],[66.458669,-54.403887],[68.265696,-55.596123],[70.244407,-55.781719],[72.328151,-54.970934],[74.450279,-53.174027],[75.988842,-51.163434],[76.393588,-50.052430],[76.562508,-48.653230],[76.214452,-44.337060],[74.987849,-36.908567],[73.647521,-31.668489],[71.470672,-25.661340],[68.830198,-19.805417],[66.098999,-15.019017],[64.811132,-12.639872],[64.131433,-8.918952],[63.865890,-1.587780],[63.820489,11.622123],[63.820489,34.873623],[67.849129,39.732523],[69.777720,42.272077],[70.986357,44.399402],[71.460779,46.140953],[71.186723,47.523185],[70.149928,48.572553],[68.336132,49.315512],[65.731073,49.778517],[62.320489,49.988023],[58.460129,49.543705],[55.146310,48.037885],[52.433993,45.507359],[50.378139,41.988923],[43.022655,25.246873],[40.942782,21.103326],[39.369839,18.591423],[36.496029,13.757423],[36.054367,12.816230],[35.504444,12.579785],[34.593719,13.096584],[33.069649,14.415123],[26.777849,19.920623],[24.122369,22.975896],[21.998835,27.189760],[20.390868,32.604505],[19.282089,39.262423],[18.609799,44.933323],[22.715139,47.524923],[25.308043,49.589421],[26.650793,51.597060],[26.826241,52.504765],[26.656606,53.308505],[26.131042,53.978363],[25.238699,54.484423],[21.408901,55.103670],[16.054404,55.056673],[10.687502,54.437426],[6.820489,53.339923],[4.941337,52.254785],[3.794137,51.048673],[3.119515,49.301060],[2.658099,46.591423],[1.827489,36.591423],[1.133157,31.989257],[-0.451516,27.841723],[-2.648436,24.685913],[-3.889585,23.647747],[-5.179511,23.058923],[-11.322861,21.721923],[-13.364146,21.420996],[-14.591673,21.606285],[-15.370830,22.468543],[-16.067006,24.198523],[-18.461785,28.270873],[-22.673653,33.627523],[-26.295269,38.255423],[-28.042410,41.760573],[-28.214322,43.096734],[-27.919136,44.157748],[-27.157362,44.945462],[-25.929507,45.461723],[-23.459194,46.596960],[-20.679507,48.501923],[-19.073191,49.891951],[-18.380093,50.839273],[-18.499723,51.652345],[-19.331590,52.639623],[-20.768226,53.675935],[-22.792242,54.527618],[-28.116032,55.622760],[-34.330205,55.816384],[-40.462005,54.999823]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-21.935609,52.247523],[-21.491570,51.538348],[-21.474470,50.786441],[-22.520997,49.318048],[-24.675004,48.169566],[-27.536308,47.668223],[-29.324469,47.567780],[-30.227744,47.288960],[-30.395415,46.712521],[-29.976764,45.719223],[-29.432706,43.591760],[-29.526646,41.105723],[-29.614245,39.517565],[-29.059375,37.933110],[-27.661874,35.990812],[-25.221581,33.329123],[-22.778870,30.605834],[-21.096203,28.189810],[-19.952293,25.696743],[-19.125855,22.742323],[-18.534888,17.721723],[-18.859405,12.360028],[-20.056795,6.958590],[-22.084449,1.818763],[-23.191020,-0.817876],[-23.068481,-1.107980],[-22.503490,-0.762487],[-20.831069,1.169795],[-19.231417,4.032731],[-17.817153,7.586536],[-16.700897,11.591423],[-15.995903,14.222177],[-15.147174,15.994735],[-13.921761,17.249062],[-12.086711,18.325123],[-8.697767,19.733760],[-5.456611,20.686023],[-2.320711,21.313223],[-4.227751,17.452323],[-5.730928,13.697435],[-6.666971,10.091423],[-6.870982,8.060173],[-6.799314,7.785173],[-6.614171,8.091423],[-0.939351,19.861723],[1.950049,25.878913],[3.521879,30.152748],[4.251444,34.454295],[4.614049,40.554623],[5.077589,50.977123],[8.969289,52.534323],[13.292509,53.696202],[17.850147,54.094235],[21.590453,53.724812],[22.825436,53.251176],[23.461679,52.584323],[23.435827,51.676126],[22.875543,50.378173],[20.381099,47.026923],[17.835219,43.602973],[17.280928,42.271913],[17.254429,41.284223],[18.765249,34.591523],[19.859942,29.543523],[20.984344,25.772323],[22.352849,22.688348],[24.179849,19.702023],[26.044814,16.727498],[26.820509,15.038023],[28.716970,13.430585],[33.276539,10.653223],[38.013242,7.816810],[40.335559,6.067223],[41.092789,5.378110],[42.066619,5.091523],[42.292603,5.312829],[42.073994,5.915398],[40.507599,7.896223],[38.609842,10.087885],[37.820509,11.418623],[39.026308,13.233585],[41.925359,16.589423],[44.120618,19.250091],[45.820484,22.144648],[47.348247,25.943516],[49.027199,31.317123],[53.002839,43.426223],[54.046577,44.712958],[55.630743,45.840679],[57.600620,46.770897],[59.801489,47.465123],[62.078631,47.884867],[64.277328,47.991641],[66.242860,47.746956],[67.820509,47.112323],[68.476715,46.408101],[68.464927,45.269498],[66.070509,40.250723],[62.820509,34.337823],[62.820509,12.273723],[62.553740,-3.519640],[62.263166,-8.411020],[61.905919,-10.355677],[61.390895,-10.318218],[60.664692,-9.798370],[58.964779,-7.664697],[55.932056,-3.751107],[51.883594,0.515889],[48.339658,3.653611],[47.231968,4.335658],[46.820509,4.179383],[48.289259,1.812031],[51.820509,-2.002227],[55.059212,-5.252055],[56.521399,-7.077615],[56.621790,-7.525146],[56.320641,-7.699233],[54.570509,-7.337237],[54.043681,-7.353155],[54.386958,-7.966340],[57.416579,-10.671427],[62.077005,-14.727416],[65.742860,-18.767906],[68.572483,-22.994417],[70.724209,-27.608467],[72.088854,-31.694235],[72.708817,-34.979922],[72.601755,-37.671317],[71.785329,-39.974207],[71.263222,-41.423096],[71.384103,-41.786899],[71.759629,-41.908467],[72.939872,-42.812101],[74.359889,-44.984667],[75.177517,-46.718342],[75.450415,-47.958190],[75.178801,-49.086277],[74.362889,-50.484667],[72.679226,-52.086985],[70.607397,-52.852561],[68.699543,-52.696790],[67.979653,-52.246960],[67.507809,-51.535067],[67.027458,-50.916725],[66.064794,-50.774647],[61.650819,-52.002417],[56.770297,-53.308371],[52.178400,-53.797699],[48.068763,-53.466873],[44.635019,-52.312367],[42.977265,-51.552978],[41.684557,-51.254897],[40.504494,-51.402796],[39.184679,-51.981347],[37.347144,-52.536278],[35.471964,-52.384988],[33.689008,-51.653886],[32.128145,-50.469382],[30.919245,-48.957889],[30.192176,-47.245815],[30.076808,-45.459571],[30.703009,-43.725567],[31.472818,-42.164955],[31.260670,-41.985423],[30.647309,-42.114347],[29.420547,-43.055381],[28.333749,-44.723157],[27.746160,-45.659095],[26.953087,-46.342291],[25.975344,-46.759805],[24.833749,-46.898697],[21.779090,-46.245274],[17.426079,-44.568089],[12.688986,-42.267243],[8.482079,-39.742837],[5.320489,-37.567477],[8.099009,-40.572457],[10.877539,-43.577447],[5.599009,-44.700697],[-1.352601,-46.024574],[-6.712145,-46.590332],[-11.425383,-46.436668],[-16.438076,-45.602277],[-32.403466,-42.550947],[-37.914531,-41.352634],[-43.057278,-39.746216],[-47.798344,-37.752447],[-52.104366,-35.392086],[-55.941982,-32.685888],[-59.277829,-29.654610],[-62.078546,-26.319007],[-64.310770,-22.699837],[-65.349557,-20.271699],[-66.116949,-17.473381],[-66.981286,-10.087337],[-67.079834,-5.110440],[-66.754655,-0.563680],[-65.938255,3.722179],[-64.563140,7.916369],[-62.561813,12.188124],[-59.866780,16.706679],[-56.410546,21.641267],[-52.125616,27.161123],[-51.023361,28.737741],[-50.547151,30.339823],[-50.629291,32.637229],[-51.202088,36.299823],[-51.623977,39.538647],[-51.663386,42.342971],[-51.294802,44.760612],[-50.492709,46.839385],[-49.231593,48.627107],[-47.485939,50.171593],[-45.230234,51.520660],[-42.438963,52.722123],[-40.358981,53.249871],[-37.617927,53.597776],[-31.198781,53.778273],[-25.273882,53.312045],[-23.150638,52.851543],[-21.935589,52.247523]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[42.011799,-16.584667],[39.084939,-18.619947],[35.896950,-21.789507],[32.874691,-25.612708],[30.445019,-29.608907],[29.372598,-32.416929],[28.902008,-35.260964],[29.050271,-37.853885],[29.834409,-39.908567],[30.249805,-40.415802],[30.446703,-40.316881],[30.204559,-38.210887],[30.079962,-36.405942],[30.349185,-34.438558],[30.992396,-32.346278],[31.989762,-30.166646],[34.967629,-25.695503],[39.124129,-21.325477],[42.118255,-18.740547],[44.260952,-17.407974],[46.391157,-16.982602],[49.347809,-17.119277],[51.950534,-17.498033],[54.394993,-18.217012],[56.822080,-19.329180],[59.372689,-20.887497],[63.252347,-23.358756],[63.102523,-22.937541],[61.820489,-21.474307],[59.644285,-19.381243],[57.293519,-17.689627],[54.812633,-16.410430],[52.246065,-15.554621],[49.638258,-15.133171],[47.033651,-15.157048],[44.476684,-15.637224],[42.011799,-16.584667]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[40.042999,-26.465267],[39.008180,-27.371304],[38.315863,-28.396396],[37.965452,-29.535730],[37.956352,-30.784494],[38.959692,-33.591055],[41.321109,-36.777577],[43.102385,-38.896531],[44.083522,-40.562327],[44.415514,-42.148969],[44.249359,-44.030457],[43.988043,-46.636885],[44.388816,-46.467604],[45.248739,-45.467437],[46.434850,-43.597843],[46.676834,-41.853454],[45.934083,-39.937428],[44.165989,-37.552927],[41.511489,-34.408567],[45.665989,-34.101067],[48.009932,-33.857092],[49.249730,-33.358040],[49.736283,-32.284206],[49.820489,-30.315887],[49.875153,-28.422329],[50.153759,-27.515014],[50.828230,-27.411625],[52.070489,-27.929847],[53.715660,-28.608531],[51.959709,-26.965027],[50.761055,-26.140601],[49.344215,-25.528213],[46.126102,-24.950877],[42.845614,-25.255677],[40.042999,-26.465267]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[36.363199,-40.839467],[36.231298,-41.811894],[37.045193,-42.460800],[38.571083,-42.697675],[40.575169,-42.434007],[42.377552,-41.719236],[42.354306,-41.332451],[41.768339,-40.855177],[40.233049,-40.184450],[38.634463,-39.957719],[37.251530,-40.175791],[36.363199,-40.839477]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[53.390519,-41.795257],[53.449574,-42.791706],[54.361109,-43.942287],[55.213441,-44.494696],[56.091982,-44.694856],[58.406489,-44.051337],[60.010249,-42.945750],[60.357430,-42.381790],[60.317859,-41.904317],[59.018891,-41.196469],[56.848677,-40.933171],[54.681218,-41.128181],[53.390519,-41.795257]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[68.832139,-45.386797],[68.024040,-47.663946],[68.215545,-48.511410],[68.802439,-49.386807],[70.103843,-50.358379],[70.737134,-50.264359],[71.453179,-49.798457],[72.436145,-48.490648],[72.769677,-46.916270],[72.452384,-45.344205],[71.482879,-44.043337],[70.775795,-43.625718],[70.150427,-43.684009],[68.832149,-45.386797]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[33.379229,-44.813527],[33.047627,-46.197464],[33.334885,-47.841247],[34.099318,-49.323706],[35.199239,-50.223667],[36.533199,-50.319185],[37.911169,-49.846907],[38.501065,-49.298805],[38.527354,-48.624767],[36.693769,-46.335437],[34.562094,-44.657472],[33.845449,-44.503212],[33.379229,-44.813527]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-57.919921,51.188923],[-54.465075,50.503115],[-52.714499,49.708810],[-52.385392,49.183207],[-52.370847,48.525162],[-53.136773,46.671323],[-53.901456,44.001710],[-53.808622,40.922823],[-52.644699,34.411112],[-52.455158,32.276120],[-52.593756,30.555835],[-53.110386,29.000855],[-54.054943,27.361777],[-57.427408,22.833723],[-62.076953,16.250085],[-65.513551,10.591423],[-68.086384,5.591423],[-68.132944,9.704923],[-67.876451,14.136023],[-67.194390,19.012923],[-66.735943,21.997548],[-66.813760,24.299673],[-67.566415,26.704773],[-69.132483,29.998323],[-71.897975,35.980898],[-74.064476,41.614573],[-75.360533,46.105623],[-75.514696,48.660323],[-74.346755,49.853285],[-72.319204,50.687523],[-68.679505,51.599923],[-66.984512,51.889249],[-64.532662,51.913610],[-57.919919,51.188923]]);
    }
  }
}


module poly_path3044(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[2.554677,-9.049483],[2.613732,-10.045931],[3.525267,-11.196513],[4.377599,-11.748921],[5.256139,-11.949081],[7.570647,-11.305563],[9.174407,-10.199975],[9.521588,-9.636015],[9.482017,-9.158543],[8.183049,-8.450694],[6.012834,-8.187396],[3.845376,-8.382407],[2.554677,-9.049483]]);
  }
}

module poly_path3050(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-8.824043,16.161107],[-11.750903,14.125828],[-14.938892,10.956267],[-17.961151,7.133067],[-20.390823,3.136867],[-21.463244,0.328845],[-21.933834,-2.515189],[-21.785571,-5.108110],[-21.001433,-7.162793],[-20.586037,-7.670027],[-20.389139,-7.571106],[-20.631283,-5.465113],[-20.755880,-3.660167],[-20.486657,-1.692783],[-19.843446,0.399497],[-18.846081,2.579129],[-15.868213,7.050272],[-11.711713,11.420297],[-8.717587,14.005227],[-6.574891,15.337801],[-4.444686,15.763173],[-1.488033,15.626497],[1.114692,15.247742],[3.559151,14.528762],[5.986238,13.416595],[8.536847,11.858277],[12.416504,9.387019],[12.266680,9.808233],[10.984647,11.271467],[8.808443,13.364532],[6.457677,15.056148],[3.976790,16.335345],[1.410223,17.191154],[-1.197584,17.612604],[-3.802191,17.588726],[-6.359158,17.108551],[-8.824043,16.161107]]);
  }
}

module poly_path3048(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-10.792843,6.280507],[-11.827663,5.374470],[-12.519979,4.349378],[-12.870390,3.210044],[-12.879491,1.961281],[-11.876151,-0.845281],[-9.514733,-4.031803],[-7.733457,-6.150756],[-6.752321,-7.816553],[-6.420328,-9.403194],[-6.586483,-11.284683],[-6.847799,-13.891110],[-6.447027,-13.721829],[-5.587103,-12.721663],[-4.400993,-10.852069],[-4.159008,-9.107679],[-4.901759,-7.191653],[-6.669853,-4.807153],[-9.324353,-1.662793],[-5.169853,-1.355293],[-2.825910,-1.111317],[-1.586112,-0.612265],[-1.099560,0.461568],[-1.015353,2.429887],[-0.960689,4.323446],[-0.682083,5.230761],[-0.007612,5.334149],[1.234647,4.815927],[2.879818,4.137244],[1.123867,5.780747],[-0.074787,6.605174],[-1.491627,7.217562],[-4.709741,7.794897],[-7.990228,7.490098],[-10.792843,6.280507]]);
  }
}

module poly_path3042(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[17.996297,-12.641023],[17.188198,-14.918171],[17.379703,-15.765636],[17.966597,-16.641033],[19.268001,-17.612604],[19.901292,-17.518585],[20.617337,-17.052683],[21.600303,-15.744873],[21.933834,-14.170495],[21.616542,-12.598431],[20.647037,-11.297563],[19.939952,-10.879943],[19.314584,-10.938234],[17.996307,-12.641023]]);
  }
}

module poly_path3046(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-14.472643,-8.093693],[-14.604544,-9.066119],[-13.790649,-9.715025],[-12.264759,-9.951900],[-10.260673,-9.688233],[-8.458291,-8.973461],[-8.481536,-8.586676],[-9.067503,-8.109403],[-10.602794,-7.438676],[-12.201379,-7.211944],[-13.584312,-7.430017],[-14.472643,-8.093703]]);
  }
}

module poly_path3040(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-17.456613,-12.067753],[-17.788215,-13.451689],[-17.500957,-15.095473],[-16.736525,-16.577931],[-15.636603,-17.477893],[-14.302643,-17.573410],[-12.924673,-17.101133],[-12.334778,-16.553031],[-12.308488,-15.878993],[-14.142073,-13.589663],[-16.273748,-11.911698],[-16.990393,-11.757437],[-17.456613,-12.067753]]);
  }
}

module poly_path3132(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[50.617341,-55.815816],[47.448232,-55.385737],[44.304841,-54.190816],[41.055367,-53.056326],[39.917027,-53.162400],[38.804841,-53.690816],[37.036395,-54.614324],[35.515877,-54.657574],[33.647654,-53.647133],[30.836091,-51.409566],[28.620995,-49.715693],[26.687534,-48.640012],[24.781477,-48.074108],[22.648591,-47.909566],[19.005831,-47.419976],[15.867341,-46.253316],[14.133591,-45.397286],[12.264752,-45.111943],[9.462832,-45.397286],[4.929841,-46.253316],[-1.493653,-47.332341],[-7.122816,-47.783679],[-12.249088,-47.610461],[-17.163909,-46.815816],[-32.070159,-44.378316],[-37.325643,-43.543488],[-41.742704,-42.537534],[-45.698492,-41.256659],[-49.570159,-39.597066],[-55.706960,-36.351927],[-60.127120,-33.104573],[-63.417236,-29.314402],[-66.163909,-24.440816],[-69.163909,-18.128316],[-69.163909,2.559184],[-69.453487,18.595791],[-69.814879,23.159770],[-70.320159,25.402934],[-72.007482,29.748964],[-74.043423,36.415072],[-75.780232,43.114161],[-76.570159,47.559134],[-76.495447,49.077605],[-76.069887,50.212722],[-75.199151,51.114795],[-73.788909,51.934134],[-72.071723,52.486664],[-69.646187,52.895936],[-63.572480,53.273347],[-57.372613,53.043652],[-52.851409,52.184134],[-51.361307,51.735347],[-50.038266,51.650909],[-48.699921,51.942484],[-47.163909,52.621734],[-43.984219,53.935984],[-40.445159,54.996734],[-34.314206,55.815816],[-28.101894,55.627834],[-22.779965,54.538353],[-20.756563,53.688538],[-19.320159,52.652934],[-18.487642,51.662752],[-18.366579,50.843297],[-19.058244,49.889611],[-20.663909,48.496734],[-23.443597,46.596222],[-25.913909,45.465434],[-27.142016,44.948765],[-27.904454,44.159975],[-28.200576,43.097439],[-28.029740,41.759534],[-26.284611,38.251119],[-22.663909,33.621734],[-18.458490,28.276397],[-16.070159,24.215434],[-15.373069,22.481798],[-14.591899,21.611497],[-13.362359,21.418164],[-11.320159,21.715434],[-5.163909,23.059134],[-3.874284,23.647936],[-2.633928,24.685980],[-0.439414,27.841372],[1.142852,31.988470],[1.836091,36.590434],[2.679841,46.590434],[3.140297,49.300306],[3.812808,51.048434],[4.957898,52.255063],[6.836091,53.340434],[10.701235,54.439767],[16.064026,55.063047],[21.414412,55.114095],[25.242341,54.496734],[26.134353,53.990276],[26.659046,53.319364],[26.827449,52.514135],[26.650589,51.604722],[25.305196,49.593886],[22.711091,47.527934],[18.773591,45.027934],[18.617341,44.840434],[19.273591,39.277934],[20.383032,32.619719],[21.992457,27.204309],[24.117448,22.989763],[26.773591,19.934134],[33.086091,14.402934],[34.607015,13.084616],[35.510821,12.568309],[36.053824,12.805266],[36.492341,13.746734],[39.367341,18.590434],[40.943870,21.103698],[43.031632,25.250247],[50.398591,41.996734],[52.453687,45.515255],[55.164337,48.046072],[58.476489,49.552220],[62.336091,49.996734],[65.746786,49.787432],[68.352141,49.325027],[70.166355,48.582935],[71.203629,47.534572],[71.478164,46.153354],[71.004161,44.412698],[69.795819,42.286020],[67.867341,39.746734],[63.836091,34.871734],[63.836091,11.621734],[63.881919,-1.585675],[64.148404,-8.911314],[64.829045,-12.626691],[66.117341,-15.003316],[68.846376,-19.792325],[71.482088,-25.653988],[73.654177,-31.666877],[74.992341,-36.909566],[76.219931,-44.335642],[76.570159,-48.646498],[76.402400,-50.042860],[75.998666,-51.151388],[74.461091,-53.159566],[72.337652,-54.959619],[70.251023,-55.777327],[68.269428,-55.598654],[66.461091,-54.409566],[65.481493,-53.656057],[64.246737,-53.404888],[59.179841,-54.409566],[54.342342,-55.487642],[50.617341,-55.815816]]);
  }
}


union()
{

scale([.65,.65,.65])
{
union()
{
//full body
translate([0,0,-4]) {
poly_path3132(8);
}

translate([0,0,-5]) {
union()
{
//body outline
poly_path3007(10);

//head
translate([14.5,9.5,0])
{
poly_path3044(10);
poly_path3050(10);
poly_path3048(10);
poly_path3042(10);
poly_path3046(10);
poly_path3040(10);
}
}
}
}
}

//valve
translate([2,-22,0])
{
rotate(a=90, v=[0,0,1])
{
rotate(a=90, v=[0,1,0])
{
difference()
{
	union()
	{
		cylinder(11,5,5,$fs=.25);
		translate([0,0,10]) sphere(4,$fs=.25);
 		translate([0,0,1]) for ( i = [0 : 23] )
		{
   			 rotate( i * 360 / 24, [0, 0, 1])
   			 cube([5.3,.5,9]);
		}
	}
	union()
	{
		translate([0,0,-1]) cylinder(10,intdia,intdia);
		translate([0,0,8.5]) cylinder(1.5,4.4,2.9,$fs=.25);
		translate([0,0,9]) sphere(3,$fs=.25);
		translate([-5,-5,13.5]) cube([10,10,3]);
	}
}

}
}
}

}

