/*
Usage:
over serial console, control servos by going
###X, where ### is 3 digits between 000 and 180, and X is A or B 
*/


#include <Servo.h> 
 
Servo myservoA;  // create servo object to control a servo 
Servo myservoB;  // create servo object to control a servo 
 
int myservoTPos = 0;
int myservoAPos = 0;    // variable to store the servo position 
int myservoBPos = 0;    // variable to store the servo position 

int i=0;
int byteCount = 0;
char serialdata[80];
 
void setup() 
{ 
 myservoA.attach(9);  // attaches the servo on pin 9 to the servo object 
 myservoB.attach(10);  // attaches the servo on pin 10 to the servo object 
 Serial.begin(9600);
 Serial.flush();
} 


void loop() 
{ 

  byteCount=Serial.readBytesUntil('q', serialdata, 80);
  if (serialdata[3]=='A' or serialdata[3]=='B')  
    {
    Serial.println("Command State");
    
    for(i=0;i<3;i+=1)
      {
        if(serialdata[i]<48 or serialdata[i]>57)
          {
            //not a number,ignore and exit
            i=5;
            Serial.println("Not a command - reset and exit");
          }
        else
        {
         //put decimal value in there 
         serialdata[i]=serialdata[i]-48;
        }
      }  
     if (i!=5)
       {
        Serial.println("1st check passed - all numbers");
        myservoTPos = (100 * serialdata[0])+(10 * serialdata[1]) + serialdata[2];
        if(myservoTPos>=0 and myservoTPos<=180)
          {
          Serial.println("Within Legal Range");
          if (serialdata[3]=='A')
            {
              myservoA.write(myservoTPos);
              Serial.print("Set servo A to: ");
              Serial.println(myservoTPos, DEC);            
            }
          if (serialdata[3]=='B')
            {
              myservoB.write(myservoTPos);
              Serial.print("Set servo B to: ");
              Serial.println(myservoTPos, DEC);            
            }
            
          }
        else
      {
          Serial.println("Out of range");
      }  
        
       }  

    }
  
  Serial.print("I received: ");
  Serial.println(serialdata);

  //Reset the buffer here
  serialdata[3]='Q';
        
/*  for(pos = 0; pos < 180; pos += 1)  // goes from 0 degrees to 180 degrees 
  {                                  // in steps of 1 degree 
    myservo1.write(pos);              // tell servo to go to position in variable 'pos' 
    myservo2.write(pos);
    delay(15);                       // waits 15ms for the servo to reach the position 
  } 
  for(pos = 180; pos>=1; pos-=1)     // goes from 180 degrees to 0 degrees 
  {                                
    myservo1.write(pos);              // tell servo to go to position in variable 'pos' 
    myservo2.write(pos);              // tell servo to go to position in variable 'pos' 
    delay(15);                       // waits 15ms for the servo to reach the position 
  }
*/ 
} 
