var express = require('express')
var app = express()
var bodyParser = require('body-parser')
var sqlite3 = require('sqlite3').verbose()
const nodemailer = require("nodemailer");

var Config = {
  SensorTriggerValue: 200,
  NumberOfReadingsAboveTriggerValue: 2,
  SecondsAboveTriggerValue: 240,
  SecondsBetweenAlerts: 1800,
  SecondsBetweenAlertChecks: 10,
  SMTPserver: "REPLACE", //Assume port 25
  AlertEmailFrom: "REPLACE",
  AlertEmailTo: "REPLACE",
  AlertsOn: true
}

app.use(bodyParser.json());

var db = new sqlite3.Database('watersensorlog.db');

var server = app.listen(3000, function () {

    var host = server.address().address
    var port = server.address().port
  
    console.log('Water sensor listening At http://%s:%s', host, port)
  
  })

//this is the loop for checking how often 
setInterval(function(){ testalert()},Config.SecondsBetweenAlertChecks *1000);

app.get('/', function(req, res) {
	res.send("Hello"); 
});

app.post('/sensorvalue', function (req, res) {
    //console.log(req.body);
    console.log(req.body.sensorvalue);
    var sensorvalue = parseInt(req.body.sensorvalue);
    if (isNaN(sensorvalue)) {
      console.log('bad value, ignore')
    }
    else {
      query = "insert into log ( timestamp, value) values (current_timestamp,"+sensorvalue+");";
    
      console.log(query);
      db.run(query);
    }
    res.sendStatus(200);
})



function testalert() {
  //lets delete records older than a day so the DB doesn't grow
  db.run("delete from log where timestamp < datetime(current_timestamp, '-86400 seconds')");

  db.serialize(function() {
    console.log("Checking number of readings that meet conditions");
    db.all("select * from log where timestamp > DATETIME(current_timestamp, '-"+Config.SecondsAboveTriggerValue+" seconds') and value > "+Config.SensorTriggerValue+";", function(err, row) {
      console.log("Number of readings:"+row.length);
      if(row.length >= Config.NumberOfReadingsAboveTriggerValue){
        db.all("select * from lock where current_timestamp > datetime(timestamp, '+"+Config.SecondsBetweenAlerts+" seconds');", function(err, row) {
          if(row.length > 0){
            //no current lock, set lock and send alert
            console.log("send alert, alerts on (T/F)"+ Config.AlertsOn);
            db.run("update lock set timestamp = current_timestamp where id =1;");
            if (Config.AlertsOn==true) {sendemailalert();}
          }
          else {
            console.log("don't send alert - sent one recently")
          }
      });
    
      }
    });
  });
  



}

async function sendemailalert(){

  query = "update lock set timestamp = current_timestamp where id =1;";
  console.log(query);
  db.run(query);


  let transporter = nodemailer.createTransport({
    host: Config.SMTPserver,
    port: 25,
    secure: false, // true for 465, false for other ports
//    auth: {
//      user: testAccount.user, // generated ethereal user
//      pass: testAccount.pass // generated ethereal password
//    }
  });

 // send mail with defined transport object
 let info = await transporter.sendMail({
  from: Config.AlertEmailFrom, // sender address
  to: Config.AlertEmailTo, // list of receivers
  subject: "Water leak Alert", // Subject line
  text: "Your air conditioner is leaking, turn off A/C", // plain text body
  html: "<b>Your air conditioner is leaking, turn off A/C</b>" // html body
});

console.log("Message sent: %s", info.messageId);
// Message sent: <b658f8ca-6296-ccf4-8306-87d57a0b4321@example.com>

// Preview only available when sending through an Ethereal account
console.log("Preview URL: %s", nodemailer.getTestMessageUrl(info));

}
