//Power Saving
#include <Narcoleptic.h>
//Power Notes: 
//Circuit consumes about 40 mA, 44 mA when transmitting
//Soil moisture sensor was negligeable
//APC220 wireless is about 8 mA
//The UBEC is 14 mA
//The circuit in Sleep Mode is 6 MA
//The circuit in regular mode 18 mA
//BMP180
#include <SFE_BMP180.h>
#include <Wire.h>
//DHT22
#include <dht.h>


//BMP180
// You will need to create an SFE_BMP180 object, here called "pressure":
SFE_BMP180 pressure;
//#define ALTITUDE 1655.0 // Altitude of SparkFun's HQ in Boulder, CO. in meters
  //Richard Note
  //55 Ellerslie is at 182 m, 
  // typical apartment 1st floor is 4.65m, each floor is 3.1m
  // we are on 18, but there is no 13, and we want the bottom of the floor, so let's say
  // = 4.65 + (15 x 3.1m) = 51 m
  // height from sea level
#define ALTITUDE 233.0 // Altitude of 55 ellerslie, ground of 18th floor

//DHT22
dht DHT;

#define DHT22_PIN 3
int sensorPin = A0;
int sensorValue = 0; 
int wirelessEnablePin = 4;  

struct
{
    uint32_t total;
    uint32_t ok;
    uint32_t crc_error;
    uint32_t time_out;
    uint32_t connect;
    uint32_t ack_l;
    uint32_t ack_h;
    uint32_t unknown;
} stat = { 0,0,0,0,0,0,0,0};

void setup()
{
  pinMode(wirelessEnablePin, OUTPUT);
  digitalWrite(wirelessEnablePin, HIGH); 
  delay(5000); //it looks like it takes some time for the wireless module to get started up.  .5 sec seemed to do it, let's add some buffer in case a wireless connection has to be established  
  Serial.begin(9600);
  Serial.println("\nMSG|REBOOT");

  // Initialize the sensor (it is important to get calibration values stored on the device).

  if (pressure.begin())
    Serial.println("\nMSG|BMP180 init success");
  else
  {
    // Oops, something went wrong, this is usually a connection problem,
    // see the comments at the top of this sketch for the proper connections.

    Serial.println("\nERR|BMP180 init fail\n\n");
    while(1); // Pause forever.
  }
}

void loop()
{
	Serial.print("\nDATA");
        read_bmp180();
	read_dht22();
      
        sensorValue = analogRead(sensorPin);   
        Serial.print("|SS=");
        Serial.println(sensorValue,DEC);
	
        delay(5000); //required to flush serial buffer

        // shut down wireless receiver as power saving measure
        digitalWrite(wirelessEnablePin, LOW); 
        for (int x=0;x<30;x++) //pause for 15 min
         { 
          Narcoleptic.delay(30000); //limited to 32767
         }
        delay(50); //because we needed a pause for the serial part to work, let's add one after before we enable wireless
        // turn it back on for next transmission
        digitalWrite(wirelessEnablePin, HIGH); 
        delay(2000); //it looks like it takes some time for the wireless module to get started up.  .5 sec seemed to do it, let's add some buffer in case a wireless connection has to be established

}

void read_bmp180()
{
  char status;
  double T,P,p0,a;

  // Loop here getting pressure readings every 10 seconds.

  // If you want sea-level-compensated pressure, as used in weather reports,
  // you will need to know the altitude at which your measurements are taken.
  // We're using a constant called ALTITUDE in this sketch:
  
  // If you want to measure altitude, and not pressure, you will instead need
  // to provide a known baseline pressure. This is shown at the end of the sketch.

  // You must first get a temperature measurement to perform a pressure reading.
  
  // Start a temperature measurement:
  // If request is successful, the number of ms to wait is returned.
  // If request is unsuccessful, 0 is returned.

  status = pressure.startTemperature();
  if (status != 0)
  {
    // Wait for the measurement to complete:
    delay(status);

    // Retrieve the completed temperature measurement:
    // Note that the measurement is stored in the variable T.
    // Function returns 1 if successful, 0 if failure.

    status = pressure.getTemperature(T);
    if (status != 0)
    {
      // Print out the measurement:
      Serial.print("|T2=");
      Serial.print(T,1);
      
      // Start a pressure measurement:
      // The parameter is the oversampling setting, from 0 to 3 (highest res, longest wait).
      // If request is successful, the number of ms to wait is returned.
      // If request is unsuccessful, 0 is returned.

      status = pressure.startPressure(3);
      if (status != 0)
      {
        // Wait for the measurement to complete:
        delay(status);

        // Retrieve the completed pressure measurement:
        // Note that the measurement is stored in the variable P.
        // Note also that the function requires the previous temperature measurement (T).
        // (If temperature is stable, you can do one temperature measurement for a number of pressure measurements.)
        // Function returns 1 if successful, 0 if failure.

        status = pressure.getPressure(P,T);
        if (status != 0)
        {
          // Print out the measurement:
          //Serial.print("absolute pressure: ");
          //Serial.print(P,2);
          //Serial.print(" mb, ");
          //Serial.print(P*0.0295333727,2);
          //Serial.println(" inHg");

          // The pressure sensor returns abolute pressure, which varies with altitude.
          // To remove the effects of altitude, use the sealevel function and your current altitude.
          // This number is commonly used in weather reports.
          // Parameters: P = absolute pressure in mb, ALTITUDE = current altitude in m.
          // Result: p0 = sea-level compensated pressure in mb

          p0 = pressure.sealevel(P,ALTITUDE); // we're at 1655 meters (Boulder, CO)
          //Serial.print("relative (sea-level) pressure: ");
          Serial.print("|P1=");
          Serial.print(p0,1);
          //Serial.print(" mb, ");
          //Serial.print(p0*0.0295333727,2);
          //Serial.println(" inHg");

          // On the other hand, if you want to determine your altitude from the pressure reading,
          // use the altitude function along with a baseline pressure (sea-level or other).
          // Parameters: P = absolute pressure in mb, p0 = baseline pressure in mb.
          // Result: a = altitude in m.

          //a = pressure.altitude(P,p0);
          //Serial.print("computed altitude: ");
          //Serial.print(a,0);
          //Serial.print(" meters, ");
          //Serial.print(a*3.28084,0);
          //Serial.println(" feet");
        }
        else Serial.println("\nERR|error retrieving pressure measurement\n");
      }
      else Serial.println("\nERR|error starting pressure measurement\n");
    }
    else Serial.println("\nERR|error retrieving temperature measurement\n");
  }
  else Serial.println("\nERR|error starting temperature measurement\n");


}


void read_dht22()
{
    // READ DATA
    //Serial.print("DHT22, \t");

    uint32_t start = micros();
    int chk = DHT.read22(DHT22_PIN);
    uint32_t stop = micros();

    stat.total++;
    switch (chk)
    {
    case DHTLIB_OK:
        stat.ok++;
        //Serial.print("OK,\t");
        break;
    case DHTLIB_ERROR_CHECKSUM:
        stat.crc_error++;
        Serial.println("\nERR|Checksum error,\t");
        break;
    case DHTLIB_ERROR_TIMEOUT:
        stat.time_out++;
        Serial.println("\nERR|Time out error,\t");
        break;
    case DHTLIB_ERROR_CONNECT:
        stat.connect++;
        Serial.println("\nERR|Connect error,\t");
        break;
    case DHTLIB_ERROR_ACK_L:
        stat.ack_l++;
        Serial.println("\nERR|Ack Low error,\t");
        break;
    case DHTLIB_ERROR_ACK_H:
        stat.ack_h++;
        Serial.println("\nERR|Ack High error,\t");
        break;
    default:
        stat.unknown++;
        Serial.println("\nERR|Unknown error,\t");
        break;
    }
    // DISPLAY DATA
    Serial.print("|H1=");
    Serial.print(DHT.humidity, 1);
    Serial.print("|T1=");
    Serial.print(DHT.temperature, 1);

    if (stat.total % 20 == 0)
    {
        Serial.print("\nERR|TOT\tOK\tCRC\tTO\tUNK");
        Serial.print("\nERR|");
        Serial.print(stat.total);
        Serial.print("\t");
        Serial.print(stat.ok);
        Serial.print("\t");
        Serial.print(stat.crc_error);
        Serial.print("\t");
        Serial.print(stat.time_out);
        Serial.print("\t");
        Serial.print(stat.connect);
        Serial.print("\t");
        Serial.print(stat.ack_l);
        Serial.print("\t");
        Serial.print(stat.ack_h);
        Serial.print("\t");
        Serial.print(stat.unknown);
        Serial.println("\n");
    }
}
