var request = require('request');
var fs = require('fs');

//Config
var data = fs.readFileSync('./getyahooweatherconfig.json'),Config;
try {
  Config = JSON.parse(data);
}
catch (err) {
  console.log('Error parsing config')
  console.log(err);
}

var yahooWeather;

request('https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22toronto%2C%20on%22%29%20AND%20u%3D%22c%22&format=json&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys&callback=', function (error, response, body) {
	yahooWeather = JSON.parse(body);
//    yahooWeather = jsonObject.query.results.channel;
	var result = yahooWeather.query.results.channel,
	weather = {},
	forecast,
	compass = ['N', 'NNE', 'NE', 'ENE', 'E', 'ESE', 'SE', 'SSE', 'S', 'SSW', 'SW', 'WSW', 'W', 'WNW', 'NW', 'NNW', 'N'],
	image404 = "https://s.yimg.com/os/mit/media/m/weather/images/icons/l/44d-100567.png";

weather.title = result.item.title;
weather.temp = result.item.condition.temp;
weather.code = result.item.condition.code;
weather.todayCode = result.item.forecast[0].code;
weather.currently = result.item.condition.text;
weather.high = result.item.forecast[0].high;
weather.low = result.item.forecast[0].low;
weather.text = result.item.forecast[0].text;
weather.humidity = result.atmosphere.humidity;
weather.pressure = result.atmosphere.pressure;
weather.rising = result.atmosphere.rising;
weather.visibility = result.atmosphere.visibility;
weather.sunrise = result.astronomy.sunrise;
weather.sunset = result.astronomy.sunset;
weather.description = result.item.description;
weather.city = result.location.city;
weather.country = result.location.country;
weather.region = result.location.region;
weather.updated = result.item.pubDate;
weather.link = result.item.link;
weather.units = {temp: result.units.temperature, distance: result.units.distance, pressure: result.units.pressure, speed: result.units.speed};
weather.wind = {chill: result.wind.chill, direction: compass[Math.round(result.wind.direction / 22.5)], speed: result.wind.speed};

//console.log("temp: "+weather.temp+" humidity:"+weather.humidity+" pressure:"+weather.pressure+" speed:"+result.wind.speed);

var mysql = require('mysql');
var db = mysql.createConnection({
  host     : Config.host,
  user     : Config.user,
  password : Config.password,
  database : Config.database
});

console.log("INSERT into readings (temperature, humidity, barometer,windspeed,idstations) VALUES ("+weather.temp+","+weather.humidity+","+weather.pressure+","+result.wind.speed+",1)");

db.query("INSERT into readings (temperature, humidity, barometer,windspeed,idstations) VALUES ("+weather.temp+","+weather.humidity+","+weather.pressure+","+result.wind.speed+",1)");

var sqlstring;

weather.forecast = [];
for(var i=0;i<result.item.forecast.length;i++) {
forecast = result.item.forecast[i];
weather.forecast.push(forecast);
}

sqlstring = "update forecast set forecast = '"+JSON.stringify(weather.forecast)+"' where idstations =1;"

db.query(sqlstring);
db.end();




})


