var request = require('request');
var fs = require('fs');

//Config
var data = fs.readFileSync('./serialwebclientconfig.json'),Config;
try {
  Config = JSON.parse(data);
}
catch (err) {
  console.log('Error parsing config')
  console.log(err);
}

//Station ID
var idstations = Config.idstations;
//DB DETAILS
var mysql = require('mysql');
var pool = mysql.createPool({
  host     : Config.host,
  user     : Config.user,
  password : Config.password,
  database : Config.database
});

// DB Pool thing - avoid connection timeout
exports.connection = {
    query: function () {
        var queryArgs = Array.prototype.slice.call(arguments),
            events = [],
            eventNameIndex = {};

        pool.getConnection(function (err, conn) {
            if (err) {
                if (eventNameIndex.error) {
                    eventNameIndex.error();
                }
            }
            if (conn) { 
                var q = conn.query.apply(conn, queryArgs);
                q.on('end', function () {
                    conn.release();
                });

                events.forEach(function (args) {
                    q.on.apply(q, args);
                });
            }
        });

        return {
            on: function (eventName, callback) {
                events.push(Array.prototype.slice.call(arguments));
                eventNameIndex[eventName] = callback;
                return this;
            }
        };
    }
};

//serial port - it's the first argument
var port = process.argv[2];

var serialport = require("serialport");
var SerialPort = serialport.SerialPort;


var serialPort = new SerialPort(port, {
  baudrate: 9600,
  parser: serialport.parsers.readline("\n")
});

serialPort.on("open", function () {
  console.log('open');
  serialPort.on('data', function(data) {
	console.log(data);
	if (data.substring(0,4) == "DATA")
		{
			var weatherdata = data.split("|");
			var temperature;
			var humidity;
			var barometer;
			var windspeed;
			var temperature2;
			var soilmoisture;
			for (index = 0; index < weatherdata.length; ++index) {
				measurement =weatherdata[index].split("=");
				if (measurement[0] == "T1")
					{
						temperature = measurement[1].trim();
					}
				if (measurement[0] == "T2")
					{
						temperature2 = measurement[1].trim();
					}
				if (measurement[0] == "H1")
					{
						humidity = measurement[1].trim();
					}
				if (measurement[0] == "P1".trim())
					{
						barometer = measurement[1].trim();
					}
				if (measurement[0] == "SS")
					{
						soilmoisture = measurement[1].trim();
					}

				
	//			console.log( weatherdata[index].substring(0,2));
	//			console.log( weatherdata[index].substring(
				}
			if ((typeof temperature != 'undefined')	&& (typeof temperature2 != 'undefined')	&& (typeof humidity != 'undefined')	&& (typeof barometer != 'undefined') && (typeof soilmoisture != 'undefined')) 
				{
					console.log("reading received");
					pool.query("INSERT into readings (temperature, humidity, barometer,temperature2,soilmoisture,idstations) VALUES ("+temperature+","+humidity+","+barometer+","+temperature2+","+soilmoisture+","+idstations+")")
							  .on('result', function (row) {
								console.log("reading updated");
							  })
							  .on('error', function (err) {
								callback({error: true, err: err});
							  });

				}
					var readings = {
						temperature: temperature,
						temperature2: temperature2,
						humidity: humidity,
						barometer: barometer,
						soilmoisture: soilmoisture,
						idstations: Config.idstations
						};	

					auth = "Basic " + new Buffer(":" + Config.httppassword).toString("base64");

					request({
						url: Config.url, //URL to hit
						//qs: readings, //Query string data
						json: true,
						method: 'POST',
						headers: {
							'content-type': 'application/json',
							'authorization' : auth
						},
						body: readings //JSON.stringify(readings) //Set the body as a string
					}, function(error, response, body){
						if(error) {
							console.log(error);
						} else {
							console.log(response.statusCode, body);
						}
					});


		}
	else
	{
		console.log(data);
	}
  });
});  
	





