var express = require('express')
var app = express()
var mysql = require('mysql');
var fs = require('fs');

//Config
var data = fs.readFileSync('./weatherserverconfig.json'),Config;
try {
  Config = JSON.parse(data);
}
catch (err) {
  console.log('Error parsing config')
  console.log(err);
}

//Setup DB pool
var pool  = mysql.createPool({
  host     : Config.host,
  user     : Config.user,
  password : Config.password,
  database : Config.database
});

//apparently, POST needs this:
var bodyParser = require('body-parser')
app.use( bodyParser.json() );       // to support JSON-encoded bodies
//app.use(bodyParser.urlencoded({       extended: true}));  // to support URL-encoded bodies


var server = app.listen(Config.port, function () {

  var host = server.address().address
  var port = server.address().port

  console.log('Weather Server App Listening At http://%s:%s', host, port)

})

app.use('/', express.static(__dirname + '/public'));

app.get('/currency', function(req, res){

	pool.getConnection(function(err, connection) {
	connection.query( "select idstations \"station\",now(),	max(timestamp) \"last reading\",(time_to_sec(timediff(now(),max(timestamp))))/60,case when ((time_to_sec(timediff(now(),max(timestamp))))/60) > 60 then 'stale' else 'current' end  \"data currency\" from readings where idstations in (select idstations from stations where active = true) group by idstations", function(err, rows) {
		res.send(JSON.stringify(rows))
		connection.release();
		});
	});


}); 

app.get('/current', function(req, res){
	//now let's check setup the station we want readings for
	var strStation;
	var rStationDetails;
	var rReferenceDetails;
	var rWeatherUpdate;
	var strWeatherUpdate;
	var asdf;
	strStation = "1";

	if (req.query.station == "1") {strStation = "1";}	
	if (req.query.station == "0") {strStation = "0";}
	
	pool.getConnection(function(err, connection) {
	connection.query("select s.name, r.temperature, r.barometer, r.humidity, r.windspeed, DATE_FORMAT(r.timestamp, '%Y-%m-%d %H:%i') timestamp from readings r, stations s where r.idstations = s.idstations and r.idreadings = (select max(r.idreadings) from readings r, stations s where r.idstations = s.idstations and s.idstations = "+strStation +")", function(err, row) {
		rStationDetails = row[0];
//		connection.release();
			connection.query("select s.name, r.temperature, r.barometer, r.humidity, r.windspeed, DATE_FORMAT(r.timestamp, '%Y-%m-%d %H:%i') timestamp from readings r, stations s where r.idstations = s.idstations and s.default = true and r.idreadings = (select max(r.idreadings) from readings r, stations s where r.idstations = s.idstations and s.default = true)", function(err, row) {
			rReferenceDetails = row[0];
			rWeatherUpdate=[rStationDetails,rReferenceDetails];
			strWeatherUpdate = rWeatherUpdate;
			res.send([rWeatherUpdate]);
			connection.release();
			});
		});
	});

}); 

app.get('/forecast', function(req, res){
	
	pool.getConnection(function(err, connection) {
	connection.query( "select forecast from forecast where idstations =1; ", function(err, row) {
		res.send(row[0].forecast)
		connection.release();
		});
	});
		
}); 

app.get('/data', function(req, res){
	var strSelectLine;
	var strStation;
	var strDateFormat;
	var strPeriod;
	var strQuery;
	var strGraph;
	var strUnit;
	
	//Let's setup some defaults
	strStation = "0";
	strGraph = "minmaxavg";

	//now let's setup the graph
	if (req.query.graph == "minmaxavg") {strGraph = "minmaxavg";}
	if (req.query.graph == "vsreftemp") {strGraph = "vsreftemp";}
	if (req.query.graph == "vsrefhumidity") {strGraph = "vsrefhumidity";}
	if (req.query.graph == "vsrefwind") {strGraph = "vsrefwind";}
	if (req.query.graph == "vsrefair") {strGraph = "vsrefair";}
	
	//now let's check setup the station we want readings for
	if (req.query.station == "1") {strStation = "1";}
	if (req.query.station == "0") {strStation = "0";}
	
	//now let's setup the time period
	strPeriod = "now() - INTERVAL 1 DAY group by DATE_FORMAT(timestamp, '%Y-%m-%d %H:00:00')";
	strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m-%d %h:00 %p')";
	if (req.query.period == "24h") 
		{
			strPeriod = "now() - INTERVAL 1 DAY group by DATE_FORMAT(timestamp, '%Y-%m-%d %H:00:00')";
			strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m-%d %h:00 %p')";
		}
	if (req.query.period == "7d") 
		{
			strPeriod = "now() - INTERVAL 7 DAY group by DATE_FORMAT(timestamp, '%Y-%m-%d')";
			strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m-%d')";
		}
	if (req.query.period == "1m") 
		{
			strPeriod = "now() - INTERVAL 1 MONTH group by DATE_FORMAT(timestamp, '%Y-%m-%d')";
			strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m-%d')";
		}
	if (req.query.period == "3m") 
		{
			strPeriod = "now() - INTERVAL 3 MONTH group by DATE_FORMAT(timestamp, '%Y-%m-%d')";
			strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m-%d')";
		}
	if (req.query.period == "1y") 
		{
			strPeriod = "now() - INTERVAL 1 YEAR group by DATE_FORMAT(timestamp, '%Y-%m')";
			strDateFormat = "DATE_FORMAT(r.timestamp, '%Y-%m')";
		}

//now we build the selected query

		if (strGraph  == "vsreftemp") {strUnit = "temperature";}
		if (strGraph  == "vsrefhumidity") {strUnit = "humidity";}
		if (strGraph  == "vsrefwind") {strUnit = "windspeed";}
		if (strGraph  == "vsrefair") {strUnit = "barometer";}
		
		strQuery = "select ActiveStation.timestamp timestamp, ActiveStation.ActiveUnit y1, DefaultStation.DefaultUnit y2, '0' y3 From ";
		strQuery = strQuery + "(select "+strDateFormat+" timestamp, avg(r."+strUnit+") ActiveUnit ";
		strQuery = strQuery + "from readings r ";
		strQuery = strQuery + "where ";
		strQuery = strQuery + "r.idstations = "+strStation+" ";
		strQuery = strQuery + "and r.timestamp >="+strPeriod+") ActiveStation, ";
		strQuery = strQuery + "(select "+strDateFormat+" timestamp, avg(r."+strUnit+") DefaultUnit ";
		strQuery = strQuery + "from readings r, stations s ";
		strQuery = strQuery + "where ";
		strQuery = strQuery + "r.idstations = s.idstations ";
		strQuery = strQuery + "and s.default = true ";
		strQuery = strQuery + "and r.timestamp >="+strPeriod+") DefaultStation ";
		strQuery = strQuery + "where ";
		strQuery = strQuery + "ActiveStation.timestamp = DefaultStation.timestamp ";
	//	strQuery = strQuery + "Order By ActiveStation.timestamp;";
		
		
		if (strGraph == "minmaxavg")
			{ 
			strQuery = "select "+strDateFormat+" timestamp, max(r.temperature) y1,avg(r.temperature) y2, min(r.temperature) y3 from readings r, stations s where r.idstations = s.idstations and s.idstations = "+strStation+" and r.timestamp >="+strPeriod;
			}

	pool.getConnection(function(err, connection) {
	connection.query( strQuery, function(err, rows) {
		res.send(JSON.stringify(rows))
		connection.release();
		});
	});

}); 


function isauthorized(httpauthheader, cb) {
	var auth;

    // check whether an autorization header was send    
    if (httpauthheader) {
      // only accepting basic auth, so:
      // * cut the starting "Basic " from the header
      // * decode the base64 encoded username:password
      // * split the string at the colon
      // -> should result in an array
      auth = new Buffer(httpauthheader.substring(6), 'base64').toString().split(':');
    }

    // checks if:
    // * auth array exists 
    // * first value matches the expected user 
    // * second value the expected password
    if ((!auth || auth[1] !== Config.httppassword ) && Config.requirehttppassword) { //(!auth || auth[0] !== 'test' || auth[1] !== 'test') {
		cb(false);
    } else {
		cb(true);
	}
              
  
}


app.post('/reading', function (request, response){

	isauthorized(request.headers.authorization, function(auth) {
		if (auth==false) {
			// send an Basic Auth request (HTTP Code: 401 Unauthorized)
			response.statusCode = 401;
			response.setHeader('WWW-Authenticate', 'Basic realm="hotelexistence.ca/weather"');
			// this will displayed in the browser when authorization is cancelled
			response.end('Unauthorized Login');
		}
		else {
			//this is where we can do the post
			var idstations, temperature, temperature2, barometer, soilmoisture, humidity, windspeed, strColumns, strValues,strQuery;
			
			console.log(request.body);

			strColumns = "";
			strValues = "";
			
			try {
				if (!isNaN(request.body.idstations)) {strColumns = strColumns + "idstations,"; strValues=strValues + request.body.idstations+",";}
				if (!isNaN(request.body.temperature)) {strColumns = strColumns + "temperature,"; strValues=strValues + request.body.temperature+",";}
				if (!isNaN(request.body.temperature2)) {strColumns = strColumns + "temperature2,"; strValues=strValues + request.body.temperature2+",";}
				if (!isNaN(request.body.barometer)) {strColumns = strColumns + "barometer,"; strValues=strValues + request.body.barometer+",";}
				if (!isNaN(request.body.soilmoisture)) {strColumns = strColumns + "soilmoisture,"; strValues=strValues + request.body.soilmoisture+",";}
				if (!isNaN(request.body.humidity)) {strColumns = strColumns + "humidity,"; strValues=strValues + request.body.humidity+",";}
				if (!isNaN(request.body.windspeed)) {strColumns = strColumns + "windspeed,"; strValues=strValues + request.body.windspeed +",";}
				strColumns = strColumns.slice(0,-1);
				strValues = strValues.slice(0,-1);
				//going to depend on the try...catch for cases where there is no data, etc...
				
				strQuery = "INSERT into readings ("+strColumns+") VALUES ("+strValues+")";

				console.log(strQuery);

				pool.getConnection(function(err, connection) {
				connection.query( strQuery, function(err, rows) {
					connection.release();
					});
				});
				
				response.sendStatus(200);
			}
			catch (exception) {
				response.sendStatus(404);
			}
		}
	});
});	




/* This is the version that doesn't support a password
app.post('/reading', function (request, response){
	var idstations, temperature, temperature2, barometer, soilmoisture, humidity, windspeed, strColumns, strValues,strQuery;
	
	console.log(request.body);

	strColumns = "";
	strValues = "";
	
	try {
		if (!isNaN(request.body.idstations)) {strColumns = strColumns + "idstations,"; strValues=strValues + request.body.idstations+",";}
		if (!isNaN(request.body.temperature)) {strColumns = strColumns + "temperature,"; strValues=strValues + request.body.temperature+",";}
		if (!isNaN(request.body.temperature2)) {strColumns = strColumns + "temperature2,"; strValues=strValues + request.body.temperature2+",";}
		if (!isNaN(request.body.barometer)) {strColumns = strColumns + "barometer,"; strValues=strValues + request.body.barometer+",";}
		if (!isNaN(request.body.soilmoisture)) {strColumns = strColumns + "soilmoisture,"; strValues=strValues + request.body.soilmoisture+",";}
		if (!isNaN(request.body.humidity)) {strColumns = strColumns + "humidity,"; strValues=strValues + request.body.humidity+",";}
		if (!isNaN(request.body.windspeed)) {strColumns = strColumns + "windspeed,"; strValues=strValues + request.body.windspeed +",";}
		strColumns = strColumns.slice(0,-1);
		strValues = strValues.slice(0,-1);
		//going to depend on the try...catch for cases where there is no data, etc...
		
		strQuery = "INSERT into readings ("+strColumns+") VALUES ("+strValues+")";

		console.log(strQuery);

		pool.getConnection(function(err, connection) {
		connection.query( strQuery, function(err, rows) {
			connection.release();
			});
		});
		
		response.sendStatus(200);
	}
	catch (exception) {
		response.sendStatus(404);
	}

});
*/
